#ifndef lint
static char *sccsid = "@(#) 2.7 src/somples.os2/somd/c/proxy/tstproxy.c, somx, som2.0.fix, csd2.0.4 5/5/94 14:07:49 [5/23/94 10:10:28]";
#endif

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#define INCL_DOSPROCESS
#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <somd.h>
#include <somtcnst.h>
#include "bar.h"

#define CheckEv(ev) ((ev)->_major != NO_EXCEPTION)

void makeDSOMObject(Environment *ev, Identifier aclass, SOMObject *aobject);


main()
{
    FILE          *fileref;
    Environment   ev;
    Bar           barObj;
    long          test_long;
    long          count;
    string        stringref;
    string        return_string;
    string        arg1;
    long          arg2 = 86;
    ReferenceData arg3;

    SOM_InitEnvironment(&ev);
    SOMD_Init(&ev);

    /* The <object>NewClass invocation is optional and unnecessary
     * in the client program when the class object is created in the
     * SOMInitModule function that is invoked during DLL initialization.
     */
    BarNewClass(0,0);

    /*
     *  test to see if the object exists
     */

    if ( !(fileref = fopen("fileref","r")) )
    {
	/*
	 *  if the object doesn't exist, create the object remotely  -
	 *  the local proxy is loaded by the runtime
	 */

	makeDSOMObject(&ev, "Bar", (SOMObject*) &barObj);

	stringref = _object_to_string (SOMD_ORBObject,&ev,(SOMDObject) barObj);

	fileref = fopen("fileref", "w");
	fprintf(fileref, "%s", stringref);
	fclose(fileref);
	somPrintf("Created an object of class Bar\n");
    }
    else
    {
	/*
	 *  object does exist so use string_to_object to load the proxy
	 */

	stringref = (string) SOMMalloc(1024);
	fscanf(fileref, "%s", stringref);
	barObj = (Bar) _string_to_object(SOMD_ORBObject, &ev, stringref);
	somPrintf("Found reference to an object of class Bar\n");
    }

    test_long = Bar__get_attribute_long(barObj, &ev);
    somPrintf("Initial attribute_long = %d\n", test_long);

    /* set, get and print long attribute */
    Bar__set_attribute_long(barObj, &ev, 8888);
    test_long = Bar__get_attribute_long(barObj, &ev);
    somPrintf("Modified attribute_long = %d\n", test_long);

    arg3._maximum = sizeof("ReferenceData");
    arg3._length = sizeof("ReferenceData");
    arg3._buffer = "ReferenceData";

    somPrintf("Invoking remote Bar method1\n");
    return_string = Bar_method1(barObj, &ev, &arg1, &arg2, &arg3);

    somPrintf("Should return: 'method1 completed', 'abc', 100\n");
    somPrintf("return_string = %s\n", return_string);
    somPrintf("arg1 = %s\n", arg1);
    somPrintf("arg2 = %d\n\n", arg2);

    for (count = 0; count < 5; count++)
    {
	DosSleep(100);
	Bar__set_attribute_long(barObj, &ev, count);
	test_long = Bar__get_attribute_long(barObj, &ev);
	somPrintf("Incremented attribute_long = %d\n", test_long);
    };

    SOMD_Uninit(&ev);
    SOM_UninitEnvironment(&ev);
    return(0);
}


void makeDSOMObject(Environment *ev, Identifier aclass, SOMObject *aobject)
{
    /* Create an object of class specified by aclass parameter. */
    somPrintf("Invoking somdNewObject to create object of class %s\n", aclass);
    *aobject = _somdNewObject(SOMD_ObjectMgr, ev, aclass, "");

    if (CheckEv(ev) || *aobject == NULL)
    {
       somPrintf("somdNewObject(%s) error\n", aclass);
       exit(1);
    }
}

